//formInnerXDimension = 80;
//formInnerYDimension = 30;
//formInnerZDimension = 30;
//formWallThickness = 2;
//formScrewRadius = 1.8;
//
//customEnclosure(formInnerXDimension, formInnerYDimension, formInnerZDimension, formWallThickness, formScrewRadius);

//$fn = 100;
//$vpr=[55,0,135];

module customEnclosure(innerXDimension,innerYDimension,innerZDimension,wallThickness, screwRadius){
    echo("customEnclosure(innerXDimension,innerYDimension,innerZDimension,wallThickness, screwRadius)");
    difference (){
        shell(innerXDimension,innerYDimension,innerZDimension,wallThickness);
        translate([(innerXDimension)/2+wallThickness,(innerYDimension)/2+wallThickness,(innerZDimension)/2+wallThickness*3]){
            innards(innerXDimension,innerYDimension,innerZDimension,wallThickness);
        }
    }
    translate([innerXDimension/2+wallThickness,innerYDimension*2+wallThickness*3,wallThickness/2]){
        difference(){
            lid(innerXDimension,innerYDimension,wallThickness);
            countersunkHolePattern(innerXDimension,innerYDimension,wallThickness, screwRadius+0.2);
        }
    }
    translate([innerXDimension/2+wallThickness,innerYDimension/2+wallThickness,innerZDimension/1+wallThickness*1.5]){
        difference(){
            intersection(){
                lidShelves(innerXDimension,innerYDimension,innerZDimension,wallThickness, screwRadius);
                translate([0,0,-innerZDimension/2 - wallThickness*2]){
                    innards(innerXDimension,innerYDimension,innerZDimension,wallThickness);
                }
            }
            lid(innerXDimension,innerYDimension,wallThickness);
            holePattern(innerXDimension,innerYDimension,wallThickness, screwRadius);
        }
    }
}

module countersunkHolePattern(innerXDimension,innerYDimension,wallThickness, screwRadius){
    xTranslation = innerXDimension/2-wallThickness - screwRadius;
    yTranslation = innerYDimension/2-wallThickness - screwRadius;
    translate([xTranslation,yTranslation,0]){
        cylinder(wallThickness*20, screwRadius, screwRadius, center = true);
        cylinder(wallThickness+.001, screwRadius, screwRadius*2, center = true);
    }
    translate([-xTranslation,-yTranslation,0]){
        cylinder(wallThickness*20, screwRadius, screwRadius, center = true);
        cylinder(wallThickness+.001, screwRadius, screwRadius*2, center = true);
    }
    translate([-xTranslation,yTranslation,0]){
        cylinder(wallThickness*20, screwRadius, screwRadius, center = true);
        cylinder(wallThickness+.001, screwRadius, screwRadius*2, center = true);
    }
    translate([xTranslation,-yTranslation,0]){
        cylinder(wallThickness*20, screwRadius, screwRadius, center = true);
        cylinder(wallThickness+.001, screwRadius, screwRadius*2, center = true);
    }
}

module lidShelves(innerXDimension,innerYDimension,innerZDimension,wallThickness, screwRadius){
    xTranslation = innerXDimension/2-wallThickness*.5;
    yTranslation = innerYDimension/2-wallThickness*.5;
    zTranslation = -wallThickness;
    sphereSize = (4*screwRadius + wallThickness);
    translate([xTranslation,yTranslation,zTranslation]){
        sphere(sphereSize);
    }
    translate([-xTranslation,-yTranslation,zTranslation]){
        sphere(sphereSize);
    }
    translate([-xTranslation,yTranslation,zTranslation]){
        sphere(sphereSize);
    }
    translate([xTranslation,-yTranslation,zTranslation]){
        sphere(sphereSize);
    }
}

module holePattern(innerXDimension,innerYDimension,wallThickness, screwRadius){
    xTranslation = innerXDimension/2-wallThickness - screwRadius;
    yTranslation = innerYDimension/2-wallThickness - screwRadius;
    translate([xTranslation,yTranslation,0]){
        cylinder(wallThickness*20, screwRadius, screwRadius, center = true);
    }
    translate([-xTranslation,-yTranslation,0]){
        cylinder(wallThickness*20, screwRadius, screwRadius, center = true);
    }
    translate([-xTranslation,yTranslation,0]){
        cylinder(wallThickness*20, screwRadius, screwRadius, center = true);
    }
    translate([xTranslation,-yTranslation,0]){
        cylinder(wallThickness*20, screwRadius, screwRadius, center = true);
    }
}

module lid(innerXDimension,innerYDimension,wallThickness){
    cube([innerXDimension+wallThickness*2,innerYDimension+wallThickness*2,wallThickness], center = true);
}

module innards(innerXDimension,innerYDimension,innerZDimension,wallThickness){
    cube([innerXDimension, innerYDimension, innerZDimension+wallThickness*4], center = true);
}

module shell(innerXDimension,innerYDimension,innerZDimension,wallThickness){
    translate([innerXDimension/2+wallThickness,innerYDimension/2+wallThickness,innerZDimension/2+wallThickness]){
        cube([innerXDimension+wallThickness*2, innerYDimension+wallThickness*2, innerZDimension+wallThickness*2], center = true);
    }
}